Ext.data.JsonP.sol_common_UserUtils({"tagname":"class","name":"sol.common.UserUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.UserUtils.js","href":"lib_sol.common.UserUtils.html#sol-common-UserUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"elojc":true,"eloas":true,"eloix":true,"requires":["sol.common.Cache","sol.common.JsonUtils","sol.common.RepoUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"adminUsersById","tagname":"property","owner":"sol.common.UserUtils","id":"property-adminUsersById","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"serviceUsersById","tagname":"property","owner":"sol.common.UserUtils","id":"property-serviceUsersById","meta":{"private":true}},{"name":"usersByGuid","tagname":"property","owner":"sol.common.UserUtils","id":"property-usersByGuid","meta":{"private":true}},{"name":"usersById","tagname":"property","owner":"sol.common.UserUtils","id":"property-usersById","meta":{"private":true}},{"name":"usersByName","tagname":"property","owner":"sol.common.UserUtils","id":"property-usersByName","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addUsersToGroups","tagname":"method","owner":"sol.common.UserUtils","id":"method-addUsersToGroups","meta":{}},{"name":"checkCurrentPermissions","tagname":"method","owner":"sol.common.UserUtils","id":"method-checkCurrentPermissions","meta":{}},{"name":"createUser","tagname":"method","owner":"sol.common.UserUtils","id":"method-createUser","meta":{}},{"name":"getCurrentUserInfo","tagname":"method","owner":"sol.common.UserUtils","id":"method-getCurrentUserInfo","meta":{}},{"name":"getFolderUserNameData","tagname":"method","owner":"sol.common.UserUtils","id":"method-getFolderUserNameData","meta":{}},{"name":"getFolderUserNameDataEloProfile","tagname":"method","owner":"sol.common.UserUtils","id":"method-getFolderUserNameDataEloProfile","meta":{}},{"name":"getFolderUserNameInbox","tagname":"method","owner":"sol.common.UserUtils","id":"method-getFolderUserNameInbox","meta":{}},{"name":"getFolderUserNamePrivate","tagname":"method","owner":"sol.common.UserUtils","id":"method-getFolderUserNamePrivate","meta":{}},{"name":"getMailAddress","tagname":"method","owner":"sol.common.UserUtils","id":"method-getMailAddress","meta":{}},{"name":"getSupervisor","tagname":"method","owner":"sol.common.UserUtils","id":"method-getSupervisor","meta":{}},{"name":"getSupervisorHierarchy","tagname":"method","owner":"sol.common.UserUtils","id":"method-getSupervisorHierarchy","meta":{}},{"name":"getUserFolder","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserFolder","meta":{}},{"name":"getUserIdFromTicket","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserIdFromTicket","meta":{}},{"name":"getUserInfo","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserInfo","meta":{}},{"name":"getUserInfoFromCache","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserInfoFromCache","meta":{"private":true}},{"name":"getUserInfoFromTicket","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserInfoFromTicket","meta":{}},{"name":"getUserInfos","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserInfos","meta":{}},{"name":"getUserNames","tagname":"method","owner":"sol.common.UserUtils","id":"method-getUserNames","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"initializeSpecialUserCaches","tagname":"method","owner":"sol.common.UserUtils","id":"method-initializeSpecialUserCaches","meta":{"private":true}},{"name":"isInGroup","tagname":"method","owner":"sol.common.UserUtils","id":"method-isInGroup","meta":{}},{"name":"isMainAdmin","tagname":"method","owner":"sol.common.UserUtils","id":"method-isMainAdmin","meta":{}},{"name":"isMainAdminTicket","tagname":"method","owner":"sol.common.UserUtils","id":"method-isMainAdminTicket","meta":{}},{"name":"isServiceUser","tagname":"method","owner":"sol.common.UserUtils","id":"method-isServiceUser","meta":{}},{"name":"isUserGuid","tagname":"method","owner":"sol.common.UserUtils","id":"method-isUserGuid","meta":{}},{"name":"isUserId","tagname":"method","owner":"sol.common.UserUtils","id":"method-isUserId","meta":{}},{"name":"removeUsersFromGroups","tagname":"method","owner":"sol.common.UserUtils","id":"method-removeUsersFromGroups","meta":{}},{"name":"requireUserInfos","tagname":"method","owner":"sol.common.UserUtils","id":"method-requireUserInfos","meta":{}},{"name":"useSpecialCaches","tagname":"method","owner":"sol.common.UserUtils","id":"method-useSpecialCaches","meta":{"private":true}},{"name":"userExists","tagname":"method","owner":"sol.common.UserUtils","id":"method-userExists","meta":{}},{"name":"writeUserInfoToCache","tagname":"method","owner":"sol.common.UserUtils","id":"method-writeUserInfoToCache","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.UserUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.UserUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Cache' rel='sol.common.Cache' class='docClass'>sol.common.Cache</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils' target='_blank'>lib_sol.common.UserUtils.js</a></div></pre><div class='doc-contents'><p>User utilities</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-adminUsersById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-property-adminUsersById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-property-adminUsersById' class='name expandable'>adminUsersById</a> : <a href=\"#!/api/sol.common.Cache\" rel=\"sol.common.Cache\" class=\"docClass\">sol.common.Cache</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>The optimized cache for administrative users. ...</div><div class='long'><p>The optimized cache for administrative users.\nThis will be initialized with all administrative users on first access.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-serviceUsersById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-property-serviceUsersById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-property-serviceUsersById' class='name expandable'>serviceUsersById</a> : <a href=\"#!/api/sol.common.Cache\" rel=\"sol.common.Cache\" class=\"docClass\">sol.common.Cache</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>The optimized cache for service users. ...</div><div class='long'><p>The optimized cache for service users.\nThis will be initialized with all service users on first access.</p>\n</div></div></div><div id='property-usersByGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-property-usersByGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-property-usersByGuid' class='name expandable'>usersByGuid</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-usersById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-property-usersById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-property-usersById' class='name expandable'>usersById</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-usersByName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-property-usersByName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-property-usersByName' class='name expandable'>usersByName</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addUsersToGroups' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-addUsersToGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-addUsersToGroups' class='name expandable'>addUsersToGroups</a>( <span class='pre'>userNames, groupNames</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds memberships\n\nsol.common.UserUtils.addUsersToGroups(\n  ['Max Brey', 'Steven Grog'],\n  ['Accounting']\n); ...</div><div class='long'><p>Adds memberships</p>\n\n<pre><code><a href=\"#!/api/sol.common.UserUtils-method-addUsersToGroups\" rel=\"sol.common.UserUtils-method-addUsersToGroups\" class=\"docClass\">sol.common.UserUtils.addUsersToGroups</a>(\n  ['Max Brey', 'Steven Grog'],\n  ['Accounting']\n);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userNames</span> : Array<div class='sub-desc'><p>Name of the member</p>\n</div></li><li><span class='pre'>groupNames</span> : Array<div class='sub-desc'><p>Names of the groups</p>\n</div></li></ul></div></div></div><div id='method-checkCurrentPermissions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-checkCurrentPermissions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-checkCurrentPermissions' class='name expandable'>checkCurrentPermissions</a>( <span class='pre'>flagNames</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks the permissions of the current user ...</div><div class='long'><p>Checks the permissions of the current user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flagNames</span> : Array<div class='sub-desc'><p>Flags, e.g. \"FLAG_IMPORT\"</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>missingPermissions</p>\n</div></li></ul></div></div></div><div id='method-createUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-createUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-createUser' class='name expandable'>createUser</a>( <span class='pre'>userName, [params]</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates an user or group ...</div><div class='long'><p>Creates an user or group</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userName</span> : String<div class='sub-desc'><p>User name</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>checkIfAlreadyExists</span> : Boolean (optional)<div class='sub-desc'><p>Don't create the user if it already exists.</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>type</span> : String (optional)<div class='sub-desc'><p>ID</p>\n<p>Defaults to: <code>id</code></p></div></li><li><span class='pre'>type</span> : String (optional)<div class='sub-desc'><p>Type</p>\n<p>Defaults to: <code>user</code></p></div></li><li><span class='pre'>desc</span> : String (optional)<div class='sub-desc'><p>Description</p>\n</div></li><li><span class='pre'>superiorId</span> : Integer (optional)<div class='sub-desc'><p>Superior ID</p>\n</div></li><li><span class='pre'>windowsUserName</span> : String (optional)<div class='sub-desc'><p>Windows user name</p>\n</div></li><li><span class='pre'>password</span> : String<div class='sub-desc'><p>password (optional) Password</p>\n</div></li><li><span class='pre'>locked</span> : Boolean (optional)<div class='sub-desc'><p>Locked</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>visible</span> : Boolean (optional)<div class='sub-desc'><p>Visible</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>email</span> : String (optional)<div class='sub-desc'><p>The E-Mail address of the new user</p>\n</div></li><li><span class='pre'>changePassword</span> : Boolenan (optional)<div class='sub-desc'><p>Change password</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>fileAccess</span> : Boolean (optional)<div class='sub-desc'><p>File Access</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>allowInteractiveLogin</span> : Boolean (optional)<div class='sub-desc'><p>Only used if creating a user. User can login.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>permissions</span> : Array (optional)<div class='sub-desc'><p>Permissions, e.g. \"FLAG_HASFILEACCESS\", \"FLAG2_SHOW_EXTRA_INFO\"</p>\n</div></li><li><span class='pre'>userProps</span> : Object (optional)<div class='sub-desc'><p>to change the \"E1\", \"E2\", \"E3\", \"E4\", \"E5\"</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>User ID</p>\n</div></li></ul></div></div></div><div id='method-getCurrentUserInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getCurrentUserInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getCurrentUserInfo' class='name expandable'>getCurrentUserInfo</a>( <span class='pre'></span> ) : de.elo.ix.client.UserInfo<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves an UserInfo object of the current user ...</div><div class='long'><p>Retrieves an UserInfo object of the current user</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo</span><div class='sub-desc'><p>The UserInfo object</p>\n</div></li></ul></div></div></div><div id='method-getFolderUserNameData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getFolderUserNameData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getFolderUserNameData' class='name expandable'>getFolderUserNameData</a>( <span class='pre'>user</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout folder username/data ...</div><div class='long'><p>Checkout folder username/data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>sord</p>\n</div></li></ul></div></div></div><div id='method-getFolderUserNameDataEloProfile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getFolderUserNameDataEloProfile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getFolderUserNameDataEloProfile' class='name expandable'>getFolderUserNameDataEloProfile</a>( <span class='pre'>user</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout folder username/data/elo.profile ...</div><div class='long'><p>Checkout folder username/data/elo.profile</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>sord</p>\n</div></li></ul></div></div></div><div id='method-getFolderUserNameInbox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getFolderUserNameInbox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getFolderUserNameInbox' class='name expandable'>getFolderUserNameInbox</a>( <span class='pre'>user</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout folder username/inbox ...</div><div class='long'><p>Checkout folder username/inbox</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>sord</p>\n</div></li></ul></div></div></div><div id='method-getFolderUserNamePrivate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getFolderUserNamePrivate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getFolderUserNamePrivate' class='name expandable'>getFolderUserNamePrivate</a>( <span class='pre'>user</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout folder username/private ...</div><div class='long'><p>Checkout folder username/private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>sord</p>\n</div></li></ul></div></div></div><div id='method-getMailAddress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getMailAddress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getMailAddress' class='name expandable'>getMailAddress</a>( <span class='pre'>user</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the email address of an ELO user ...</div><div class='long'><p>Returns the email address of an ELO user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Email address</p>\n</div></li></ul></div></div></div><div id='method-getSupervisor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getSupervisor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getSupervisor' class='name expandable'>getSupervisor</a>( <span class='pre'>user</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the supervisior user name ...</div><div class='long'><p>Returns the supervisior user name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|Number<div class='sub-desc'><p>User name or ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Supervisior user name</p>\n</div></li></ul></div></div></div><div id='method-getSupervisorHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getSupervisorHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getSupervisorHierarchy' class='name expandable'>getSupervisorHierarchy</a>( <span class='pre'>user</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the supervisior hierarchy ...</div><div class='long'><p>Returns the supervisior hierarchy</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|Number<div class='sub-desc'><p>User name or ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Supervisiors</p>\n</div></li></ul></div></div></div><div id='method-getUserFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserFolder' class='name expandable'>getUserFolder</a>( <span class='pre'>user</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout userfolder ...</div><div class='long'><p>Checkout userfolder</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>sord</p>\n</div></li></ul></div></div></div><div id='method-getUserIdFromTicket' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserIdFromTicket' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserIdFromTicket' class='name expandable'>getUserIdFromTicket</a>( <span class='pre'>ticket</span> ) : de.elo.ix.client.UserInfo<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the user ID for a given ticket ...</div><div class='long'><p>Returns the user ID for a given ticket</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ticket</span> : String<div class='sub-desc'><p>Ticket</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo</span><div class='sub-desc'><p>User info</p>\n</div></li></ul></div></div></div><div id='method-getUserInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserInfo' class='name expandable'>getUserInfo</a>( <span class='pre'>user</span> ) : de.elo.ix.client.UserInfo<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves an UserInfo object. ...</div><div class='long'><p>Retrieves an UserInfo object.</p>\n\n<p>If the parameter is already an UserInfo, it returns the object itself.\nTherefore this function can be used to make sure you're dealing with an UserInfo and not just a user name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String|de.elo.ix.client.UserInfo<div class='sub-desc'><p>The name, GUID or ID of the user (or an UserInfo object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo</span><div class='sub-desc'><p>The UserInfo object, if one was found</p>\n</div></li></ul></div></div></div><div id='method-getUserInfoFromCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserInfoFromCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserInfoFromCache' class='name expandable'>getUserInfoFromCache</a>( <span class='pre'>user</span> ) : de.elo.ix.client.UserInfo<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the user info from the cache ...</div><div class='long'><p>Retrieves the user info from the cache</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String<div class='sub-desc'><p>User ID or name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo</span><div class='sub-desc'><p>User info</p>\n</div></li></ul></div></div></div><div id='method-getUserInfoFromTicket' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserInfoFromTicket' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserInfoFromTicket' class='name expandable'>getUserInfoFromTicket</a>( <span class='pre'>ticket</span> ) : de.elo.ix.client.UserInfo<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the UserInfo for a given ticket ...</div><div class='long'><p>Returns the UserInfo for a given ticket</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ticket</span> : String<div class='sub-desc'><p>Ticket</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo</span><div class='sub-desc'><p>User info</p>\n</div></li></ul></div></div></div><div id='method-getUserInfos' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserInfos' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserInfos' class='name expandable'>getUserInfos</a>( <span class='pre'>users</span> ) : de.elo.ix.client.UserInfo[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves UserInfo objects. ...</div><div class='long'><p>Retrieves UserInfo objects.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>users</span> : String[]<div class='sub-desc'><p>The names, GUIDs or IDs of the users</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserInfo[]</span><div class='sub-desc'><p>The retrieved UserInfo objects</p>\n</div></li></ul></div></div></div><div id='method-getUserNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-getUserNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-getUserNames' class='name expandable'>getUserNames</a>( <span class='pre'>config</span> ) : de.elo.ix.client.UserName[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns user names ...</div><div class='long'><p>Returns user names</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name</p>\n</div></li><li><span class='pre'>namePart</span> : String<div class='sub-desc'><p>Name part</p>\n</div></li><li><span class='pre'>max</span> : String<div class='sub-desc'><p>maximum User names</p>\n</div></li><li><span class='pre'>visible</span> : Boolean (optional)<div class='sub-desc'><p>If set to <code>true</code>, only users with the <code>visible in userlist</code> property will be returned</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.UserName[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-initializeSpecialUserCaches' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-initializeSpecialUserCaches' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-initializeSpecialUserCaches' class='name expandable'>initializeSpecialUserCaches</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-isInGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isInGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isInGroup' class='name expandable'>isInGroup</a>( <span class='pre'>group, [params]</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a user is in a group. ...</div><div class='long'><p>Checks, if a user is in a group.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : String<div class='sub-desc'><p>Id or name of a group</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>userId</span> : Number|String (optional)<div class='sub-desc'><p>If not set, the userId from <code>ixConnect</code> will be used</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMainAdmin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isMainAdmin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isMainAdmin' class='name expandable'>isMainAdmin</a>( <span class='pre'>user</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if an user is a main admin. ...</div><div class='long'><p>Checks if an user is a main admin.</p>\n\n<p>For performance reasons this uses a separate cache for the administrative users.\nThis cache can only be used if the client version is newer then '10.17.010.005' and if this is called with an UserInfo or a Number.\nIn any other cases a fallback will be used and the performance might suffer.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo|Number|String<div class='sub-desc'><p>An UserInfo object, an user ID, name or GUID. UserInfo or user ID (Number) should be prefered due to better performance (only relevant for IX client versions above 10.17.010.005).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMainAdminTicket' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isMainAdminTicket' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isMainAdminTicket' class='name expandable'>isMainAdminTicket</a>( <span class='pre'>ticket</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the given ticket represents an administrative user ...</div><div class='long'><p>Checks if the given ticket represents an administrative user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ticket</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the user has main admin rights</p>\n</div></li></ul></div></div></div><div id='method-isServiceUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isServiceUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isServiceUser' class='name expandable'>isServiceUser</a>( <span class='pre'>user</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if an user is a service user. ...</div><div class='long'><p>Checks if an user is a service user.\nThat's the case if the user has no interactive login rights and is a main admin.</p>\n        <p>Available since: <b>1.04.000</b></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo|Number|String<div class='sub-desc'><p>An UserInfo object, an user ID, name or GUID. UserInfo or user ID (Number) should be prefered due to better performance (only relevant for IX client versions above 10.17.010.005).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isUserGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isUserGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isUserGuid' class='name expandable'>isUserGuid</a>( <span class='pre'>user</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the given string is a user GUID ...</div><div class='long'><p>Checks wether the given string is a user GUID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String<div class='sub-desc'><p>User</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isUserId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-isUserId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-isUserId' class='name expandable'>isUserId</a>( <span class='pre'>user</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the given string is a user ID ...</div><div class='long'><p>Checks wether the given string is a user ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : String<div class='sub-desc'><p>User</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeUsersFromGroups' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-removeUsersFromGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-removeUsersFromGroups' class='name expandable'>removeUsersFromGroups</a>( <span class='pre'>userNames, groupNames</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Remove memberships\n\nsol.common.UserUtils.removeUsersFromGroups([\"Everyone\"], [\"sol.contract.roles.Editors\"]); ...</div><div class='long'><p>Remove memberships</p>\n\n<pre><code><a href=\"#!/api/sol.common.UserUtils-method-removeUsersFromGroups\" rel=\"sol.common.UserUtils-method-removeUsersFromGroups\" class=\"docClass\">sol.common.UserUtils.removeUsersFromGroups</a>([\"Everyone\"], [\"sol.contract.roles.Editors\"]);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userNames</span> : Array<div class='sub-desc'><p>Name of the member</p>\n</div></li><li><span class='pre'>groupNames</span> : Array<div class='sub-desc'><p>Names of the groups</p>\n</div></li></ul></div></div></div><div id='method-requireUserInfos' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-requireUserInfos' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-requireUserInfos' class='name expandable'>requireUserInfos</a>( <span class='pre'>users</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Load user infos into the cache ...</div><div class='long'><p>Load user infos into the cache</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>users</span> : Array<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-useSpecialCaches' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-useSpecialCaches' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-useSpecialCaches' class='name expandable'>useSpecialCaches</a>( <span class='pre'>user</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Admin caches will only be used if user parameter is an UserInfo object or a Number and the IX version is above ...</div><div class='long'><p>Admin caches will only be used if <code>user</code> parameter is an UserInfo object or a <code>Number</code> and the IX version is above</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo|Number|String<div class='sub-desc'><p>An UserInfo object, an user ID, name or GUID. UserInfo or user ID (Number) should be prefered due to better performance (only relevant for IX client versions above 10.17.010.005).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-userExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-userExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-userExists' class='name expandable'>userExists</a>( <span class='pre'>userName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a user exists ...</div><div class='long'><p>Checks wether a user exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userName</span> : String<div class='sub-desc'><p>User name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-writeUserInfoToCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserUtils'>sol.common.UserUtils</span><br/><a href='source/lib_sol.common.UserUtils.html#sol-common-UserUtils-method-writeUserInfoToCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserUtils-method-writeUserInfoToCache' class='name expandable'>writeUserInfoToCache</a>( <span class='pre'>userInfo</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Write user info into the cache ...</div><div class='long'><p>Write user info into the cache</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userInfo</span> : de.elo.ix.client.UserInfo<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});